<?php

if (!class_exists('electron_insta_post_widget')) {
    class electron_insta_post_widget extends WP_Widget
    {
        /**
         * Register widget with WordPress.
         */
        function __construct()
        {
            parent::__construct(
                'electron_insta_post_widget',
                esc_html__('Electron Instagram Feed', 'electron'),
                array('description' => esc_html__('Show the Instagram Feed',
                    'electron'),)
            );
        }

        /**
         * Front-end display of widget.
         */
        public function widget($args, $instance)
        {
            echo $args['before_widget'];

            if (!empty($instance['title'])) {
                echo $args['before_title'] . apply_filters('widget_title', esc_html($instance['title']), $instance, $this->id_base) . $args['after_title'];
            }
            $username = (!empty($instance['username'])) ? strip_tags($instance['username']) : 'instagram';
            $limit = (!empty($instance['noOfPost'])) ? strip_tags($instance['noOfPost']) : 3;
            if ($username != '') {
                $media_array = electron_get_instagram($username);
                if (is_wp_error($media_array)) {
                    ?>
                    <h5 class="text-center">
                        <?php echo wp_kses_post($media_array->get_error_message()); ?>
                    </h5>
                    <?php
                } else {
                    $media_images = array_slice($media_array['images'], 0, $limit);
                    ?>
                    <div class="widget-gallery">
                        <?php foreach ($media_images as $item) { ?>
                            <a target="_blank" href="<?php echo esc_url($item['link']); ?>"
                               class="mfp-image gallery-item">
                                <div class="overlay"></div>

                                <img src="<?php echo esc_url($item['img']); ?>"
                                     alt="<?php esc_attr_e('Instagram image', 'electron'); ?>">
                            </a>
                        <?php } ?>
                    </div>
                <?php }
            }
            echo $args['after_widget'];
        }


        /**
         * Back-end widget form.
         */
        public function form($instance)
        {
            $title = !empty($instance['title']) ? $instance['title'] : esc_html__('Instagram', 'electron');
            $username = !empty($instance['username']) ? $instance['username'] : 'instagram';
            $noOfPost = !empty($instance['noOfPost']) ? $instance['noOfPost'] : 3;
            ?>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
                    <?php esc_html_e('Title :', 'electron'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text"
                       value="<?php echo esc_attr($title); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('username')); ?>">
                    <?php esc_html_e('Username :', 'electron'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('username')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('username')); ?>" type="text"
                       value="<?php echo esc_attr($username); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('noOfPost')); ?>">
                    <?php esc_html_e('Number of images to show :', 'electron'); ?>
                </label>
                <input class="tiny-text" id="<?php echo esc_attr($this->get_field_id('noOfPost')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('noOfPost')); ?>" type="number"
                       value="<?php echo esc_attr($noOfPost); ?>" step="1" min="1" size="3">
            </p>

            <?php
        }


        /**
         * Sanitize widget form values as they are saved.
         */
        public function update($new_instance, $old_instance)
        {
            $instance = array();
            $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
            $instance['username'] = (!empty($new_instance['username'])) ? strip_tags($new_instance['username']) : 'instagram';
            $instance['noOfPost'] = (!empty($new_instance['noOfPost'])) ? strip_tags($new_instance['noOfPost']) : 3;
            return $instance;
        }
    }


}
if (!function_exists('insta_register_widget')) {
    add_action('widgets_init', 'insta_register_widget');
    function insta_register_widget()
    {
        register_widget("electron_insta_post_widget");
    }
}