<div id="main">
    <div class="container-fluid">
        <div class="row">
            <?php
            $args = array(
                'posts_per_page' => 5,
                'meta_key' => '_thumbnail_id',
                'tag' => 'featured'
            );
            $featured = new WP_Query($args);
            if ($featured->have_posts()) {
            ?>
            <div class="col-md-12 p-0">
            <div class="blog-slick-slider" data-items="3">
                    <?php
                    while ($featured->have_posts()) {
                        $featured->the_post();
                        if (has_post_thumbnail()) :
                            ?>
                            <div class="blog-item">
                                <div class="blog-inner">
                                    <a href="<?php the_permalink(); ?>">
                                        <div class="overlay"></div>
                                        <img src="<?php echo esc_url(get_the_post_thumbnail_url()); ?>'" alt="<?php the_title();?>"/>
                                    </a>
                                    <div class="post-slider-content">
                                        <div class="category-links">
                                            <?php
                                            $cats = get_the_category();
                                            foreach ($cats as $cat) {
                                               echo '<a href="' . get_category_link($cat) . '">' . $cat->cat_name . '</a> ';
                                            }
                                            ?>
                                        </div>
                                        <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                        <div class="post-slider-meta">
                                            <ul>
                                                <li><a href="<?php echo get_day_link(get_the_time('Y'), get_the_time('m'), get_the_time('d')); ?>">
                                                        <?php the_time('M j, Y'); ?></a></li>
                                                <li>
                                                    <a href="<?php the_permalink(); ?>"><?php echo get_the_author_posts_link(); ?></a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif;
                    } ?>
                </div>
            </div>
           <?php } wp_reset_postdata();
             ?>
        </div>
    </div>
</div>