<?php
/*
 Template Name: Full Width 2 Home Page
 */
get_header();
?>
    <div id="main">
        <!-- Featured Slider -->
        <?php require_once(locate_template('template-parts/slider.php')); ?>
    </div>

    <div class="section mt-7">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="blog-list style-2">
                        <?php
                        $args2 = array(
                            'posts_per_page' => 5,
                        );
                        $featured = new WP_Query($args2);
                        if ($featured->have_posts()) {
                            while ($featured->have_posts()) {
                                $featured->the_post();

                                ?>
                                <div class="blog-item">
                                    <div class="blog-inner">
                                        <?php if (has_post_thumbnail()) { ?>
                                            <a href="<?php the_permalink(); ?>">
                                                <div class="overlay"><i class="mdi-link-variant"></i></div>
                                                <img src="<?php echo esc_url(get_the_post_thumbnail_url()); ?>'"
                                                     alt="<?php the_title(); ?>"/>
                                            </a>
                                        <?php } ?>
                                        <div class="info">
                                            <div class="title">
                                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                            </div>
                                            <div class="meta">
                                                <ul>
                                                    <li class="category"><?php
                                                        $cats = get_the_category();
                                                        $arr = array();
                                                        foreach ($cats as $cat) {
                                                            $arr[] = '<a href="' . get_category_link($cat) . '">' .
                                                                $cat->cat_name . '</a>';
                                                        }
                                                        echo implode(', ', $arr);
                                                        ?></li>
                                                    <li class="author"><?php esc_html_e('by ', 'electron');

                                                        echo get_the_author_posts_link(); ?></li>
                                                    <li class="date"><a
                                                                href="<?php echo get_day_link(get_the_time('Y'), get_the_time('m'), get_the_time('d')); ?>">
                                                            <?php the_time('M j, Y'); ?></a></li>
                                                    <li class="comment"><?php echo get_comments_number();
                                                        esc_html_e(' comments', 'electron'); ?></li>
                                                </ul>
                                            </div>
                                            <div class="text">
                                                <p> <?php the_excerpt(); ?> </p>
                                            </div>
                                            <div class="simple-line"></div>
                                            <div class="share">
                                                <div class="post-bottom">
                                                    <div class="continue">
                                                        <a href="<?php the_permalink(); ?>"><?php esc_html_e('Continue Reading', 'electron'); ?>
                                                            <span><i class="fa fa-long-arrow-right"></i></span></a>
                                                    </div>
                                                    <div class="share-iocn">
                                                        <?php if (function_exists('electron_social_share')) {
                                                            ?>
                                                            <span class="share"><?php esc_html_e('Share:', 'electron'); ?></span>
                                                            <span class="icon">
                                        <?php
                                        electron_social_share();
                                        ?>
                                    </span>
                                                            <?php
                                                        } ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            <?php }
                        }
                        wp_reset_postdata(); ?>

                    </div>
                    <?php require_once(locate_template('template-parts/navigation.php')); ?>
                </div>
            </div>
        </div>
    </div>


<?php get_footer(); ?>