<?php
if (post_password_required()) {
    return;
}

if (have_comments()) {
    ?>
    <div class="comments">
        <h4 class="comment-title">
            <?php echo get_comments_number();
            esc_html_e(' Comments','electron');?>
        </h4>

        <ol class="comment-list">

            <?php
            wp_list_comments(array(
                'style' => 'ol',
                'callback' => 'electron_comments_callback',
                'avatar_size' => 90,
                'depth' => 4
            )); ?>
        </ol>
        <?php
        if (get_comment_pages_count() > 1 && get_option('page_comments')) : ?>
            <div class="posts-pagination">
                <div class="alignleft">
                    <?php previous_comments_link('<i class="fa fa-angle-double-left"></i>') ?>
                </div>
                <div class="alignright">
                    <?php next_comments_link('<i
                class="fa fa-angle-double-right"></i>'); ?>
                </div>
            </div>
        <?php endif;

        if (!comments_open() && get_comments_number() && post_type_supports(get_post_type(), 'comments')) :
            ?>
            <p class="no-comments">
                <?php esc_html_e('Comments are closed.', 'electron'); ?>
            </p>
        <?php endif; ?>
    </div>

<?php }


$commenter = wp_get_current_commenter();
$req = get_option('require_name_email');
$fields = array(
    'author' => '<div class="row"><div class="col-md-4">' . '<p>' . '<label for="name">' . __(
            'Name','electron') . ($req ? ' <span class="required">*</span>' : '') . '</label> ' .
        '<input class="highlighted" id="name" name="author" type="text" value="' . esc_attr($commenter['comment_author']) . '" size="30" maxlength="245" /></p></div>',
    'email' => '<div class="col-md-4">' . '<p>' . '<label for="email">' . __('Email','electron') . ($req ? ' <span class="required">*</span>' : '') . '</label> ' .
        '<input class="highlighted" id="email" name="email" type="text" value="' . esc_attr($commenter['comment_author_email']) . '" size="30" maxlength="100" /></p></div>',
    'url' => '<div class="col-md-4">' . '<p>' . '<label for="url">' . __('Website','electron') . '</label> ' .
        '<input class="highlighted" id="url" name="url" type="text" value="' . esc_attr($commenter['comment_author_url']) . '" size="30" maxlength="200" /></p></div></div>',
);


$args = array(
    'fields' => $fields,
    'title_reply' => __('Leave a Comment','electron'),
    'title_reply_before' => '<h4 class="comment-title">',
    'title_reply_after' => '</h4>',
    'label_submit' => __('Submit Comment','electron'),
    'name_submit' => 'submit',
    'class_form' => 'comment-form clearfix',
    'must_log_in' => esc_html__('must log in', 'electron'),

    'submit_button' => '<input name="%1$s" type="submit" id="%2$s" class="%3$s button" value="%4$s" />',
    'submit_field' => '<div class="row col-md-12">%1$s %2$s</div>',
    'comment_field' =>
        '<div class="row">' .
        '<div class="col-md-12">' .
        '<label for="comment">' . esc_html__('Comment', 'electron') . '</label>' .
        '<textarea name="comment" id="comment" class="highlighted mb-3" placeholder=
       "Your comment" rows="8"></textarea>' .

        '</div></div>'

);

comment_form($args);