<?php

/**
 * Configure Kirki plugin
 */

Kirki::add_config('electron', array(
    'capability' => 'edit_theme_options',
    'option_type' => 'theme_mod',
));

/*general section */
Kirki::add_section('electron_general_style', array(
    'title' => esc_attr__('General Setting', 'electron'),
    'priority' => 10,
    'capability' => 'edit_theme_options',
));


/* control of section 1 */
Kirki::add_field('preloader_check', array(
    'type' => 'checkbox',
    'settings' => 'checkbox_preloader_setting',
    'label' => esc_attr__('Show Preloader', 'electron'),
    'section' => 'electron_general_style',
    'default' => true,
    ));

Kirki::add_field('electron_primary_font', array(
    'type' => 'typography',
    'settings' => 'electron_primary_font',
    'label' => esc_html__('Primary Font', 'electron'),
    'description' => esc_html__('Titles and headings font', 'electron'),
    'section' => 'electron_general_style',
    'default' => array(
        'font-family' => 'Cabin',
        'variant' => 'regular',
        'subsets' => array('latin-ext')
    )
));

Kirki::add_field('electron_secondary_font', array(
    'type' => 'typography',
    'settings' => 'electron_secondary_font',
    'label' => esc_html__('Secondary Font', 'electron'),
    'description' => esc_html__('Sub-headings and site content', 'electron'),
    'section' => 'electron_general_style',
    'default' => array(
        'font-family' => 'Source Sans Pro',
        'variant' => '500',
        'subsets' => array('latin-ext')
    )

));

Kirki::add_field('font_color', array(
    'type' => 'color',
    'settings' => 'font_color_setting',
    'label' => __('Primary Color', 'electron'),
    'description' => esc_attr__('Link and button color', 'electron'),
    'section' => 'electron_general_style',
    'default' => '#c9995d',
    'transport' => 'postMessage',
    'js_vars' => array(
        array(
            'element' => ':root',
            'function' => 'css',
            'property' => '--color'
        )
    )
));

/*header section */
Kirki::add_section('electron_header_style', array(
    'title' => esc_attr__('Header Setting', 'electron'),
    'capability' => 'edit_theme_options',
    'priority' => 10,
));



/* control of image section */
Kirki::add_field('images', array(
    'type' => 'image',
    'settings' => 'header_logo',
    'label' => esc_attr__('Logo Image', 'electron'),
    'description' => esc_attr__('For perfect view use 160x36 px size.', 'electron'),
    'section' => 'electron_header_style',
    'default' => '',
));

/* control of section 1 */
Kirki::add_field('search_design', array(
    'type' => 'checkbox',
    'settings' => 'checkbox_search_setting',
    'label' => esc_attr__('Search ', 'electron'),
    'description' => esc_attr__(' ', 'electron'),
    'section' => 'electron_header_style',
    'default' => true,
));


Kirki::add_section('icon_settings', array(
    'title' => esc_html__('Social Icons Setting', 'electron'),
    'priority' => 10,
    'capability' => 'edit_theme_options',
));


Kirki::add_field('header_icon_setting', array(
    'type' => 'checkbox',
    'settings' => 'header_icon_setting',
    'label' => esc_html__('Show Social Icons', 'electron'),
    'section' => 'icon_settings',
    'default' => false
));


Kirki::add_field('first_icon_type', array(
    'type' => 'text',
    'settings' => 'first_icon_type',
    'label' => esc_html__('First icon - Type', 'electron'),
    'section' => 'icon_settings',
    'description' => esc_html__('Just write a single word with lowercase letters. (facebook, twitter,
                    instagram etc. And leave empty for hide it)', 'electron'),
    'default' => '',
    'priority' => 10,

    'active_callback' => array(
        array(
            'setting' => 'header_icon_setting',
            'operator' => '==',
            'value' => true,
        ),
    )
));

Kirki::add_field('first_icon_url', array(
    'type' => 'text',
    'settings' => 'first_icon_url',
    'label' => esc_html__('First social icon - Url', 'electron'),
    'description' => esc_html__('Paste the full url of your social profile. (Leave empty for hide it)', 'electron'),
    'section' => 'icon_settings',
    'default' => '',
    'active_callback' => array(
        array(
            'setting' => 'header_icon_setting',
            'operator' => '==',
            'value' => true,
        ),
    )
));


Kirki::add_field('second_icon_type', array(
    'type' => 'text',
    'settings' => 'second_icon_type',
    'label' => esc_html__('Second social icon - Type', 'electron'),
    'description' => esc_html__('Just write a single word with lowercase letters. (facebook, twitter, instagram etc. And leave empty for hide it)', 'electron'),
    'section' => 'icon_settings',
    'default' => '',
    'active_callback' => array(
        array(
            'setting' => 'header_icon_setting',
            'operator' => '==',
            'value' => true,
        ),
    )
));

Kirki::add_field('second_icon_url', array(
    'type' => 'text',
    'settings' => 'second_icon_url',
    'label' => esc_html__('Second social icon - Url', 'electron'),
    'description' => esc_html__('Paste the full url of your social profile. (Leave empty for hide it)', 'electron'),
    'section' => 'icon_settings',
    'default' => '',
    'active_callback' => array(
        array(
            'setting' => 'header_icon_setting',
            'operator' => '==',
            'value' => true,
        ),
    )
));

Kirki::add_field('third_icon_type', array(
    'type' => 'text',
    'settings' => 'third_icon_type',
    'label' => esc_html__('Third social icon - Type', 'electron'),
    'description' => esc_html__('Just write a single word with lowercase letters. (facebook, twitter, instagram etc. And leave empty for hide it)', 'electron'),
    'section' => 'icon_settings',
    'default' => '',
    'active_callback' => array(
        array(
            'setting' => 'header_icon_setting',
            'operator' => '==',
            'value' => true,
        ),
    )
));

Kirki::add_field('third_icon_url', array(
    'type' => 'text',
    'settings' => 'third_icon_url',
    'label' => esc_html__('Third social icon - Url', 'electron'),
    'description' => esc_html__('Paste the full url of your social profile. (Leave empty for hide it)', 'electron'),
    'section' => 'icon_settings',
    'default' => '',
    'active_callback' => array(
        array(
            'setting' => 'header_icon_setting',
            'operator' => '==',
            'value' => true,
        ),
    )
));

Kirki::add_field('fourth_icon_type', array(
    'type' => 'text',
    'settings' => 'fourth_icon_type',
    'label' => esc_html__('Fourth social icon - Type', 'electron'),
    'description' => esc_html__('Just write a single word with lowercase letters. (facebook, twitter, instagram etc. And leave empty for hide it)', 'electron'),
    'section' => 'icon_settings',
    'default' => '',
    'active_callback' => array(
        array(
            'setting' => 'header_icon_setting',
            'operator' => '==',
            'value' => true,
        ),
    )
));

Kirki::add_field('fourth_icon_url', array(
    'type' => 'text',
    'settings' => 'fourth_icon_url',
    'label' => esc_html__('Fourth social icon - Url', 'electron'),
    'description' => esc_html__('Paste the full url of your social profile. (Leave empty for hide it)', 'electron'),
    'section' => 'icon_settings',
    'default' => '',
    'active_callback' => array(
        array(
            'setting' => 'header_icon_setting',
            'operator' => '==',
            'value' => true,
        ),
    )
));

Kirki::add_field('fifth_icon_type', array(
    'type' => 'text',
    'settings' => 'fifth_icon_type',
    'label' => esc_html__('Fifth social icon - Type', 'electron'),
    'description' => esc_html__('Just write a single word with lowercase letters. (facebook, twitter, instagram etc. And leave empty for hide it)', 'electron'),
    'section' => 'icon_settings',
    'default' => '',
    'active_callback' => array(
        array(
            'setting' => 'header_icon_setting',
            'operator' => '==',
            'value' => true,
        ),
    )
));

Kirki::add_field('fifth_icon_url', array(
    'type' => 'text',
    'settings' => 'fifth_icon_url',
    'label' => esc_html__('Fifth social icon - Url', 'electron'),
    'description' => esc_html__('Paste the full url of your social profile. (Leave empty for hide it)', 'electron'),
    'section' => 'icon_settings',
    'default' => '',
    'active_callback' => array(
        array(
            'setting' => 'header_icon_setting',
            'operator' => '==',
            'value' => true,
        ),
    )
));

Kirki::add_field('sixth_icon_type', array(
    'type' => 'text',
    'settings' => 'sixth_icon_type',
    'label' => esc_html__('Sixth social icon - Type', 'electron'),
    'description' => esc_html__('Just write a single word with lowercase letters. (facebook, twitter, instagram etc. And leave empty for hide it)', 'electron'),
    'section' => 'icon_settings',
    'default' => '',
    'active_callback' => array(
        array(
            'setting' => 'header_icon_setting',
            'operator' => '==',
            'value' => true,
        ),
    )
));

Kirki::add_field('sixth_icon_url', array(
    'type' => 'text',
    'settings' => 'sixth_icon_url',
    'label' => esc_html__('Sixth social icon - Url', 'electron'),
    'description' => esc_html__('Paste the full url of your social profile. (Leave empty for hide it)', 'electron'),
    'section' => 'icon_settings',
    'default' => '',
    'active_callback' => array(
        array(
            'setting' => 'header_icon_setting',
            'operator' => '==',
            'value' => true,
        ),
    )
));

Kirki::add_field('seventh_icon_type', array(
    'type' => 'text',
    'settings' => 'seventh_icon_type',
    'label' => esc_html__('Seventh social icon - Type', 'electron'),
    'description' => esc_html__('Just write a single word with lowercase letters. (facebook, twitter, instagram etc. And leave empty for hide it)', 'electron'),
    'section' => 'icon_settings',
    'default' => '',
    'active_callback' => array(
        array(
            'setting' => 'header_icon_setting',
            'operator' => '==',
            'value' => true,
        ),
    )
));

Kirki::add_field('seventh_icon_url', array(
    'type' => 'text',
    'settings' => 'seventh_icon_url',
    'label' => esc_html__('Seventh social icon - Url', 'electron'),
    'description' => esc_html__('Paste the full url of your social profile. (Leave empty for hide it)', 'electron'),
    'section' => 'icon_settings',
    'default' => '',
    'active_callback' => array(
        array(
            'setting' => 'header_icon_setting',
            'operator' => '==',
            'value' => true,
        ),
    )
));


/*main content section */
Kirki::add_section('electron_customizer_main_content', array(
    'title' => esc_attr__('Home Setting', 'electron'),
    'capability' => 'edit_theme_options',
    'priority' => 10,
));

Kirki::add_field('checkbox', array(
    'type' => 'checkbox',
    'settings' => 'checkbox_slider_setting',
    'label' => esc_attr__('Show slider', 'electron'),
    'description' => esc_attr__('Carousel only shows on home page. (You can add posts to the carousel by adding a "featured" tag.)', 'electron'),
    'section' => 'electron_customizer_main_content',
    'default' => false,
));

Kirki::add_field('radio', array(
    'type' => 'radio',
    'settings' => 'sidebar_setting',
    'label' => __('Sidebar Position', 'electron'),
    'section' => 'electron_customizer_main_content',
    'default' => 'right',
    'priority' => 10,
    'choices' => array(
        'left' => esc_attr__('Left', 'electron'),
        'right' => esc_attr__('Right', 'electron'),
        'hide' => esc_attr__('Hide', 'electron'),
    ),
));

/* control of section index */
Kirki::add_field('home_layouts', array(
    'type' => 'radio',
    'settings' => 'home_layout',
    'label' => __('Layout', 'electron'),
    'section' => 'electron_customizer_main_content',
    'default' => '1',
    'priority' => 10,
    'choices' => array(
        '1' => esc_attr__('Basic', 'electron'),
        '2' => esc_attr__('Standard', 'electron'),
        '3' => esc_attr__('Listing', 'electron'),
        '4' => esc_attr__('Grid', 'electron'),
        '5' => esc_attr__('Featured Grid', 'electron'),
        '6' => esc_attr__('Full Basic', 'electron'),
        '7' => esc_attr__('Full Standard', 'electron'),
        '8' => esc_attr__('2 Column Masonry', 'electron'),
        '9' => esc_attr__('3 Column Masonry', 'electron'),
    ),
));

Kirki::add_field('home_icon', array(
    'type' => 'checkbox',
    'settings' => 'checkbox_icon_Home_setting',
    'label' => esc_attr__('Show Social Share Icons', 'electron'),
    'section' => 'electron_customizer_main_content',
    'default' => false,
));


/*single content section */
Kirki::add_section('electron_single_content', array(
    'title' => esc_attr__('Single Setting', 'electron'),
    'capability' => 'edit_theme_options',
    'priority' => 10,
));

/* control of image section for single */
Kirki::add_field('single_layouts', array(
    'type' => 'radio',
    'settings' => 'single_layout',
    'label' => esc_attr__('Layout', 'electron'),
    'section' => 'electron_single_content',
    'choices' => array(
        '1' => esc_attr__('Layout 1', 'electron'),
        '2' => esc_attr__('Layout 2', 'electron'),
    ),
    'default' => '1'
));


Kirki::add_field('radio', array(
    'type' => 'radio',
    'settings' => 'single_sidebar_setting',
    'label' => __('Sidebar Position', 'electron'),
    'section' => 'electron_single_content',
    'default' => 'right',
    'priority' => 10,
    'choices' => array(
        'left' => esc_attr__('Left', 'electron'),
        'right' => esc_attr__('Right', 'electron'),
        'hide' => esc_attr__('Hide', 'electron'),
    ),
));

Kirki::add_field('content_icon', array(
    'type' => 'checkbox',
    'settings' => 'checkbox_icon_content_setting',
    'label' => esc_attr__('Show Social Share Icons ', 'electron'),
    'section' => 'electron_single_content',
    'default' => false,
));

Kirki::add_field('author_content', array(
    'type' => 'checkbox',
    'settings' => 'checkbox_author_content_setting',
    'label' => esc_attr__('Show About Author', 'electron'),
    'section' => 'electron_single_content',
    'default' => true,
));

Kirki::add_field('related_post', array(
    'type' => 'checkbox',
    'settings' => 'checkbox_related_post_setting',
    'label' => esc_attr__('Show Related Posts', 'electron'),
    'section' => 'electron_single_content',
    'default' => true,
));

Kirki::add_field('comment_box', array(
    'type' => 'checkbox',
    'settings' => 'checkbox_comment_box_setting',
    'label' => esc_attr__('Hide Comment Box', 'electron'),
    'description' => esc_attr__('hide all post\'s comments', 'electron'),
    'section' => 'electron_single_content',
    'default' => false,
));

/* page content section */
Kirki::add_section('electron_Page_content', array(
    'title' => esc_attr__('Page Setting', 'electron'),
    'capability' => 'edit_theme_options',
    'priority' => 10,
));

Kirki::add_field('radio', array(
    'type' => 'radio',
    'settings' => 'page_sidebar_setting',
    'label' => __('Sidebar Position', 'electron'),
    'section' => 'electron_Page_content',
    'default' => 'right',
    'priority' => 10,
    'choices' => array(
        'left' => esc_attr__('Left', 'electron'),
        'right' => esc_attr__('Right', 'electron'),
        'none' => esc_attr__('Hide', 'electron'),
    ),
));


Kirki::add_field('page_icon', array(
    'type' => 'checkbox',
    'settings' => 'checkbox_icon_page_setting',
    'label' => esc_attr__('Show Social Share Icons', 'electron'),
    'section' => 'electron_Page_content',
    'default' => false,
));


Kirki::add_field('author_page', array(
    'type' => 'checkbox',
    'settings' => 'checkbox_author_page_setting',
    'label' => esc_attr__('Show About Author', 'electron'),
    'section' => 'electron_Page_content',
    'default' => true,
));


Kirki::add_field('related_post_page', array(
    'type' => 'checkbox',
    'settings' => 'checkbox_related_post_page_setting',
    'label' => esc_attr__('Show Related Posts', 'electron'),
    'description' => esc_attr__(' ', 'electron'),
    'section' => 'electron_Page_content',
    'default' => true,
));


Kirki::add_field('comment_box_page', array(
    'type' => 'checkbox',
    'settings' => 'checkbox_comment_box_page_setting',
    'label' => esc_attr__('Hide Comment Box', 'electron'),
    'section' => 'electron_Page_content',
    'default' => false,
));

/*archive content section */
Kirki::add_section('electron_archive_content', array(
    'title' => esc_attr__('Archive Setting', 'electron'),
    'capability' => 'edit_theme_options',
    'priority' => 10,
));


Kirki::add_field('archive_side', array(
    'type' => 'radio',
    'settings' => 'archive_sidebar_setting',
    'label' => __('Sidebar Position', 'electron'),
    'section' => 'electron_archive_content',
    'default' => 'right',
    'priority' => 10,
    'choices' => array(
        'left' => esc_attr__('Left', 'electron'),
        'right' => esc_attr__('Right', 'electron'),
        'none' => esc_attr__('Hide', 'electron'),
    ),
));


Kirki::add_field('archive layout', array(
    'type' => 'radio',
    'settings' => 'archive_layout',
    'label' => __('Layout', 'electron'),
    'section' => 'electron_archive_content',
    'default' => '1',
    'priority' => 10,
    'choices' => array(
        '1' => esc_attr__('Basic', 'electron'),
        '2' => esc_attr__('Standard', 'electron'),
        '3' => esc_attr__('Listing', 'electron'),
        '4' => esc_attr__('Grid', 'electron'),
        '5' => esc_attr__('Featured Grid', 'electron'),
        '6' => esc_attr__('Full Basic', 'electron'),
        '7' => esc_attr__('Full Standard', 'electron'),
        '8' => esc_attr__('2 Column Masonry', 'electron'),
        '9' => esc_attr__('3 Column Masonry', 'electron'),
    ),
));

Kirki::add_field('archive_icon', array(
    'type' => 'checkbox',
    'settings' => 'checkbox_icon_archive_setting',
    'label' => esc_attr__('Show Social Share Icons', 'electron'),
    'section' => 'electron_archive_content',
    'default' => false,
));

/*search content section */
Kirki::add_section('electron_search_content', array(
    'title' => esc_attr__('Search Setting', 'electron'),
    'capability' => 'edit_theme_options',
    'priority' => 10,
));

Kirki::add_field('search_set', array(
    'type' => 'radio',
    'settings' => 'search_sidebar_setting',
    'label' => __('Sidebar Position', 'electron'),
    'section' => 'electron_search_content',
    'default' => 'right',
    'priority' => 10,
    'choices' => array(
        'left' => esc_attr__('Left', 'electron'),
        'right' => esc_attr__('Right', 'electron'),
        'none' => esc_attr__('Hide', 'electron'),
    ),
));

Kirki::add_field('s_layout', array(
    'type' => 'radio',
    'settings' => 'search_layout',
    'label' => __('Layout', 'electron'),
    'section' => 'electron_search_content',
    'default' => '1',
    'priority' => 10,
    'choices' => array(
        '1' => esc_attr__('Basic', 'electron'),
        '2' => esc_attr__('Standard', 'electron'),
        '3' => esc_attr__('Listing', 'electron'),
        '4' => esc_attr__('Grid', 'electron'),
        '5' => esc_attr__('Featured Grid', 'electron'),
        '6' => esc_attr__('Full Basic', 'electron'),
        '7' => esc_attr__('Full Standard', 'electron'),
        '8' => esc_attr__('2 Column Masonry', 'electron'),
        '9' => esc_attr__('3 Column Masonry', 'electron'),
    ),
));


/* control of section search */
Kirki::add_field('search_icon', array(
    'type' => 'checkbox',
    'settings' => 'checkbox_icon_search_setting',
    'label' => esc_attr__('Show Social Share Icons', 'electron'),
    'section' => 'electron_search_content',
    'default' => false,
));

/*instagram content section */
Kirki::add_section('electron_insta_content', array(
    'title' => esc_attr__('Instagram Feed Setting', 'electron'),
    'capability' => 'edit_theme_options',
    'priority' => 10,
));

/* control of section instagram */
Kirki::add_field('insta_images', array(
    'type' => 'checkbox',
    'settings' => 'checkbox_insta_image_setting',
    'label' => esc_attr__('Show Instagram Feed', 'electron'),
    'section' => 'electron_insta_content',
    'default' => false,
));

Kirki::add_field('insta_uname', array(
    'type' => 'text',
    'settings' => 'insta_username',
    'label' => esc_html__('Username', 'electron'),
    'description' => esc_html__('only username with lowercase letters, don\'t add \'@\' symbol (eg. instagram, facebook, google','electron'),
    'section' => 'electron_insta_content',
    'default' => '',

));

/* footer section */
Kirki::add_section('electron_footer_style', array(
    'title' => esc_attr__('Footer Setting', 'electron'),
    'capability' => 'edit_theme_options',
    'priority' => 10,
));


/* footer_setting control of text section */
Kirki::add_field('footer_text', array(
    'type' => 'text',
    'settings' => 'footer_setting',
    'label' => esc_attr__('Footer Copyright Text', 'electron'),
    'section' => 'electron_footer_style',
    'default' => __('&copy; Copyright 2018 Electron, All Rights Reserved', 'electron'),
    'priority' => 10,
));

/* control of image section for single */
Kirki::add_field('footer_image', array(
    'type' => 'image',
    'settings' => 'footer_bgimage',
    'label' => esc_attr__('Footer Background Image', 'electron'),
    'section' => 'electron_footer_style',
    'default' => '',
));