<?php

if (!class_exists('electron_tweets_post_widget')) {
    class electron_tweets_post_widget extends WP_Widget
    {
        /**
         * Register widget with WordPress.
         */
        function __construct()
        {
            parent::__construct(
                'electron_tweets_post_widget',
                esc_html__('Electron Twitter Feed', 'electron'),
                array('description' => esc_html__('Show Tweets Feed',
                    'electron'),)
            );
        }

        /**
         * Front-end display of widget.
         */
        public function widget($args, $instance)
        {
            echo $args['before_widget'];

            if (!empty($instance['title'])) {
                echo $args['before_title'] . apply_filters('widget_title', esc_html($instance['title']), $instance, $this->id_base) . $args['after_title'];
            }


            $username = !empty($instance['consumer_key']) ? esc_html($instance['username']) : 'wordpress';
            $consumer_key = !empty($instance['consumer_key']) ? $instance['consumer_key'] : esc_html__('c8JTZo0z1X8fKyZR8SvTTMiuQ', 'electron');
            $consumer_secret = !empty($instance['consumer_secret']) ? $instance['consumer_secret'] : esc_html__('5kBhDCgqUMQBmEAkBArrqNlOcrgoBToxQW6WQ10AOzTr77U0bJ', 'electron');
            $access_token = !empty($instance['access_token']) ? $instance['access_token'] : esc_html__('937396273467990016-ZSpAox5zfIepNLO70ttcWZ4lkTeETBH', 'electron');
            $access_token_secret = !empty($instance['access_token_secret']) ? $instance['access_token_secret'] : esc_html__('gnAeaC0Yg76O2XA3J6tUfI4JMZ3aXQR0pfyI06rrGSxXN', 'electron');

            $limit = $instance['noOfPost'];
            $request_settings = array(
                'consumer_key' => $consumer_key,
                'consumer_secret' => $consumer_secret,
                'access_token' => $access_token,
                'access_token_secret' => $access_token_secret
            );

            $tweets = electron_get_tweets($username, $limit, $request_settings);
            if (is_array($tweets)) {
                foreach ($tweets as $tweet) { ?>
                    <div class="widget-tweets">
                        <p><i class="fa fa-twitter"></i>
                            <?php
                            $pattern = '/@([a-zA-Z0-9_]+)/';
                            $replace = '<a href="http://twitter.com/$1">@$1</a>';
                            echo preg_replace($pattern, $replace, $tweet->full_text);
                            ?>
                        </p>

                        <div class="tweet-meta">
                            <a href="<?php echo esc_url('www.twitter.com/' . $tweet->user->screen_name); ?>"><?php echo '@' . $username; ?></a>
                            <?php echo human_time_diff(strtotime($tweet->created_at), current_time('timestamp')) . ' ' . esc_html__('ago', 'electron'); ?>
                        </div>
                    </div>
                <?php }
            }
            echo $args['after_widget'];
        }

        /**
         * Back-end widget form.
         */
        public function form($instance)
        {
            $title = !empty($instance['title']) ? $instance['title'] : esc_html__('Twitter', 'electron');
            $username = !empty($instance['username']) ? $instance['username'] : '';
            $consumer_key = !empty($instance['consumer_key']) ? $instance['consumer_key'] : '';
            $consumer_secret = !empty($instance['consumer_secret']) ? $instance['consumer_secret'] : '';
            $access_token = !empty($instance['access_token']) ? $instance['access_token'] : '';
            $access_token_secret = !empty($instance['access_token_secret']) ? $instance['access_token_secret'] : '';
            $noOfPost = !empty($instance['noOfPost']) ? $instance['noOfPost'] : 3;
            ?>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
                    <?php esc_html_e('Title :', 'electron'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text"
                       value="<?php echo esc_attr($title); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('username')); ?>">
                    <?php esc_html_e('Username :', 'electron'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('username')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('username')); ?>" type="text"
                       value="<?php echo esc_attr($username); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('consumer_key')); ?>">
                    <?php esc_html_e('Consumer Key :', 'electron'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('consumer_key')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('consumer_key')); ?>" type="text"
                       value="<?php echo esc_attr($consumer_key); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('consumer_secret')); ?>">
                    <?php esc_html_e('Consumer Secret:', 'electron'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('consumer_secret')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('consumer_secret')); ?>" type="text"
                       value="<?php echo esc_attr($consumer_secret); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('access_token')); ?>">
                    <?php esc_html_e('Access Token :', 'electron'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('access_token')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('access_token')); ?>" type="text"
                       value="<?php echo esc_attr($access_token); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('access_token_secret')); ?>">
                    <?php esc_html_e('Access Token Secret :', 'electron'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('access_token_secret')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('access_token_secret')); ?>" type="text"
                       value="<?php echo esc_attr($access_token_secret); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('noOfPost')); ?>">
                    <?php esc_html_e('Number of tweets to show :', 'electron'); ?>
                </label>
                <input class="tiny-text" id="<?php echo esc_attr($this->get_field_id('noOfPost')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('noOfPost')); ?>" type="number"
                       value="<?php echo esc_attr($noOfPost); ?>" step="1" min="1" size="3">
            </p>

            <?php
        }


        /**
         * Sanitize widget form values as they are saved.
         */
        public function update($new_instance, $old_instance)
        {
            $instance = array();
            $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
            $instance['username'] = (!empty($new_instance['username'])) ? strip_tags($new_instance['username']) : '';
            $instance['consumer_key'] = (!empty($new_instance['consumer_key'])) ? strip_tags($new_instance['consumer_key']) : '';
            $instance['consumer_secret'] = (!empty($new_instance['consumer_secret'])) ? strip_tags($new_instance['consumer_secret']) : '';
            $instance['access_token'] = (!empty($new_instance['access_token'])) ? strip_tags($new_instance['access_token']) : '';
            $instance['access_token_secret'] = (!empty($new_instance['access_token_secret'])) ? strip_tags($new_instance['access_token_secret']) : '';
            $instance['noOfPost'] = (!empty($new_instance['noOfPost'])) ? strip_tags($new_instance['noOfPost']) : 3;

            return $instance;
        }
    }


}
if (!function_exists('tweets_register_widget')) {
    add_action('widgets_init', 'tweets_register_widget');
    function tweets_register_widget()
    {
        register_widget("electron_tweets_post_widget");
    }
}