<?php
/**
 * Main title area above the content
 */

if (is_category()) {
    $title = esc_html__('Category : ', 'electron');
    $subtitle = ' <span class="cat">' . single_cat_title('', false) . '</span>';
} else if (is_tag()) {
    $title = esc_html__('Tag : ', 'electron');
    $subtitle = '<span class="cat">' . single_tag_title('', false) . '</span>';
} else if (is_search()) {
    $title = esc_html__('Search Results : ', 'electron');
    $subtitle = '<span class="cat">' . get_search_query() . '</span>';
} else if (is_date()) {
    $title = esc_html__('Date : ', 'electron');
    $subtitle = '<span class="cat">' . get_the_date('j M, Y') . '</span>';
} else if (is_author()) {
    $title = esc_html__('Author : ', 'electron');
    $subtitle = '<span class="cat">' . get_the_author() . '</span>';
} else {
    $title = strip_tags(get_the_title());
}

?>
<div class="archive-title">
    <h2 class="text-center">
        <?php echo  $title ;
        echo (!empty($subtitle)) ? $subtitle : '' ; ?>
    </h2>
</div>