<?php get_header();

$layout = get_theme_mod('single_layout', '1'); ?>

    <div id="main">
        <?php if ($layout == 2) { ?>
            <div class="section section-bg-1 section-fixed"
                 style="background-image: url('<?php echo esc_url(get_the_post_thumbnail_url()); ?>');">
                <div class="container-fluid">
                    <div class="row">
                        <?php
                        if (have_posts()) {
                            while (have_posts()) {
                                the_post();
                                ?>
                                <div class="col-md-12">
                                    <div class="blog-detail-header">
                                        <div class="blog-detail-header-content text-center">
                                            <div class="meta">
                                                <?php
                                                $cats = get_the_category();
                                                $arr = array();
                                                foreach ($cats as $cat) {
                                                    $arr[] = '<a href="' . get_category_link($cat) . '">' . $cat->cat_name . '</a>';
                                                }
                                                echo implode(', ', $arr);
                                                ?>
                                            </div>
                                            <h2 class="entry-title"><?php the_title(); ?></h2>

                                            <div class="info">
                                        <span class="date"><a
                                                    href="<?php echo get_day_link(get_the_time('Y'), get_the_time('m'), get_the_time('d')); ?>">
                                                <?php the_time('M j, Y'); ?></a></span>
                                                <span class="divider">-</span>
                                                <span class="author"><?php esc_html_e('Posted by', 'electron'); ?>
                                                    <?php echo get_the_author_posts_link(); ?>
                                        </span>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            <?php }
                        } ?>
                    </div>
                </div>
            </div>
        <?php } ?>
        <div class="section mt-7">
            <div class="container">
                <div class="row">
                    <?php
                    $saved_sidebar = get_theme_mod('single_sidebar_setting', 'right');
                    if ('left' == $saved_sidebar) { ?>
                        <div class="col-sm-4 mb-7">
                            <?php get_sidebar(); ?>
                        </div>
                    <?php } ?>

                    <div class="<?php echo $saved_sidebar == 'hide' ? 'col-sm-12' : 'col-md-8'; ?>">
                        <?php
                        if (have_posts()) {
                            while (have_posts()) {
                                the_post();
                                ?>
                                <div <?php post_class('blog-list') ?>>
                                    <div class="blog-item single-content">
                                        <?php if ($layout == 1) {
                                            if (has_post_thumbnail()) { ?>
                                                <img src="<?php echo esc_url(get_the_post_thumbnail_url()); ?>'"
                                                     alt="<?php the_title(); ?>"/>
                                            <?php }
                                        } ?>
                                        <div class="info">
                                            <div class="title">
                                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                            </div>
                                            <div class="meta">
                                                <ul>
                                                    <li class="category"><?php
                                                        $cats = get_the_category();
                                                        $arr = array();
                                                        foreach ($cats as $cat) {
                                                            $arr[] = '<a href="' . get_category_link($cat) . '">' . $cat->cat_name . '</a>';
                                                        }
                                                        echo implode(', ', $arr);
                                                        ?></li>
                                                    <li class="author"><?php esc_html_e('By ', 'electron'); ?><?php echo get_the_author_posts_link(); ?></li>
                                                    <li class="date"><a
                                                                href="<?php echo get_day_link(get_the_time('Y'), get_the_time('m'), get_the_time('d')); ?>">
                                                            <?php the_time('M j, Y'); ?></a></li>
                                                    <li class="comment"><?php echo get_comments_number();
                                                        esc_html_e(' Comments', 'electron'); ?></li>
                                                </ul>
                                            </div>
                                            <div class="body-text clearfix">
                                                <?php the_content();
                                                ?>
                                            </div>
                                            <div>
                                                <?php wp_link_pages(); ?>
                                            </div>

                                            <div class="simple-line mt-5"></div>
                                            <div class="share">
                                                <div class="post-bottom">
                                                    <div class="tag">
                                                        <?php if (has_tag()) { ?>
                                                            <span><?php esc_html_e('Tag:', 'electron'); ?></span>
                                                            <?php
                                                            $tags = get_the_tags();
                                                            foreach ($tags as $tag) {
                                                                echo '<a href="' . get_tag_link($tag) . '">' . $tag->name . '</a>';
                                                            }
                                                        }
                                                        ?>
                                                    </div>
                                                    <?php if (get_theme_mod('checkbox_icon_content_setting', false)) { ?>
                                                        <div class="share-iocn">
                                                            <?php if (function_exists('electron_social_share')) {
                                                                ?>
                                                                <span class="share"><?php esc_html_e('Share:', 'electron'); ?></span>
                                                                <span class="icon">
                                                                <?php electron_social_share(); ?>
                                                            </span>
                                                                <?php
                                                            } ?>
                                                        </div>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php if (get_theme_mod('checkbox_author_content_setting', true)) {
                                    if (get_the_author_meta('description')) {
                                        ?>
                                        <div class="author-info">
                                            <div class="author-avatar">
                                                <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><img
                                                            src="<?php echo esc_url(get_avatar_url(get_the_author_meta('ID'))) ?>"></a>
                                            </div>
                                            <span class="author-name"><?php echo get_the_author_posts_link(); ?></span>
                                            <div class="author-description">
                                                <?php echo get_the_author_meta('description'); ?>
                                            </div>
                                        </div>

                                    <?php }
                                } ?>
                                <?php if (get_theme_mod('checkbox_related_post_setting', true)) {
                                    $args = array(
                                        'posts_per_page' => 3,
                                        'author' => get_the_author_meta('ID'),
                                        'post__not_in' => array(get_the_ID())
                                    );
                                    $featured = new WP_Query($args);
                                    if ($featured->have_posts()) {
                                        ?>
                                        <div class="blog-detail related-post">
                                            <h4 class="title"><?php esc_html_e('Related Posts', 'electron'); ?></h4>
                                            <div class="mb-3"></div>
                                            <div class="blog-list">
                                                <div class="row">
                                                    <?php
                                                    while ($featured->have_posts()) {
                                                        $featured->the_post();
                                                        ?>
                                                        <div class="col-md-4">
                                                            <div class="blog-item">
                                                                <div class="blog-inner">
                                                                    <a href="<?php the_permalink(); ?>">
                                                                        <div class="overlay">
                                                                            <i class="mdi-link-variant"></i></div>
                                                                        <img
                                                                                src="<?php echo esc_url(get_the_post_thumbnail_url()); ?>'"
                                                                                alt="<?php the_title(); ?>"/>
                                                                    </a>
                                                                    <div class="title">
                                                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                                                    </div>
                                                                    <span class="date"><a
                                                                                href="<?php echo get_day_link(get_the_time('Y'), get_the_time('m'), get_the_time('d')); ?>">
                         <?php the_time('M j, Y'); ?></a></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                        </div>
                                    <?php }
                                    wp_reset_postdata();
                                }

                                require_once(locate_template('template-parts/navigation_page.php'));

                                if (!get_theme_mod('checkbox_comment_box_setting', false)) {
                                    comments_template();
                                }
                            }
                        } else {
                            require_once(locate_template('template-parts/content-none.php'));
                        } ?>
                    </div>
                    <?php if ('right' == $saved_sidebar) { ?>
                        <div class="col-sm-4 mb-7">
                            <?php get_sidebar(); ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>

<?php get_footer(); ?>