<?php

if (!class_exists('electron_post_sidebar_widget')) {
    class electron_post_sidebar_widget extends WP_Widget
    {
        /**
         * Register widget with WordPress.
         */
        function __construct()
        {
            parent::__construct(
                'electron_post_sidebar_custom_widget',
                esc_html__('Electron Recent post Widget', 'electron'),
                array('description' => esc_html__('Show Recent Posts',
                    'electron'),)
            );
        }

        /**
         * Front-end display of widget.
         */
        public function widget($args, $instance)
        {
            echo $args['before_widget'];

            if (!empty($instance['title'])) {
                echo $args['before_title'] . apply_filters('widget_title', esc_html($instance['title']), $instance, $this->id_base) . $args['after_title'];
            }
            $args1 = array(
                'posts_per_page' => $instance['noOfPost']
            );
            $posts = new WP_Query($args1);
            if ($posts->have_posts()) {
                $i = 0;
                ?>
                <div class="widget-recent-post">
                    <ul>
                        <?php
                        while ($posts->have_posts()) {
                            $posts->the_post();
                            if ($i < $instance['noOfPost']) {
                                ?>

                                <li>
                                    <div class="featured">
                                        <a href="<?php the_permalink(); ?>"><?php if (has_post_thumbnail()) {
                                                the_post_thumbnail();
                                            } ?></a>

                                    </div>
                                    <div class="content">
                                        <h6 class="title">
                                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h6>

                                        <div class="info">

                                            <div class="date"><a
                                                        href="<?php echo get_day_link(get_the_time('Y'), get_the_time('m'), get_the_time('d')); ?>">
                                                    <?php the_time('M j, Y'); ?></a></div>
                                        </div>
                                    </div>
                                </li>
                                <?php
                            }
                            $i++;
                        }
                        wp_reset_postdata();
                        ?>
                    </ul>
                </div>
                <?php
            }

            echo $args['after_widget'];
        }

        /**
         * Back-end widget form.
         */
        public function form($instance)
        {
            $title = !empty($instance['title']) ? $instance['title'] : '';
            $noOfPost = !empty($instance['noOfPost']) ? $instance['noOfPost'] : 3;
            ?>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
                    <?php esc_html_e('Title :', 'electron'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text"
                       value="<?php echo esc_attr($title); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('noOfPost')); ?>">
                    <?php esc_html_e('Number of posts to show :', 'electron'); ?>
                </label>
                <input class="tiny-text" id="<?php echo esc_attr($this->get_field_id('noOfPost')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('noOfPost')); ?>" type="number"
                       value="<?php echo esc_attr($noOfPost); ?>" step="1" min="1" size="3">
            </p>
            <?php
        }

        /**
         * Sanitize widget form values as they are saved.
         */
        public function update($new_instance, $old_instance)
        {
            $instance = array();
            $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
            $instance['noOfPost'] = (!empty($new_instance['noOfPost'])) ? strip_tags($new_instance['noOfPost']) : 3;
            return $instance;
        }
    }
}

if (!function_exists('electron_recent_post_widget')) {
    add_action('widgets_init', 'electron_recent_post_widget');
    function electron_recent_post_widget()
    {
        register_widget("electron_post_sidebar_widget");
    }
}